SET SQL_SAFE_UPDATES=0;
SET @dtproviderIdFather=(SELECT id FROM dtprovider WHERE `dataProviderName`='BIRTHDAY_GREETING_FATHER_DL');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery`="SELECT 
    prts.userId AS USER_ID
FROM
    users u
        INNER JOIN
    parents prts ON prts.userId = u.id
        INNER JOIN
    persons p ON p.id = prts.personId
        LEFT JOIN
    person_relationships pr ON pr.relatedPersonId = p.id
WHERE
		DATE_FORMAT(birthDate, '%m-%d') = DATE_FORMAT(NOW(), '%m-%d') AND
        p.whetherDeleted = FALSE
        AND u.status = TRUE
        AND (p.isDeceased is null or p.isDeceased=FALSE)
        AND pr.relationship = 'FATHER' group by u.id"
    
     WHERE `dataProviderId` = @dtproviderIdFather;
     
SET @dtproviderIdMother=(SELECT id FROM dtprovider WHERE `dataProviderName`='BIRTHDAY_GREETING_MOTHER_DL');

UPDATE `sql_dtprovider` 
SET 
    `sqlQuery`="SELECT 
    prts.userId AS USER_ID
FROM
    users u
        INNER JOIN
    parents prts ON prts.userId = u.id
        INNER JOIN
    persons p ON p.id = prts.personId
        LEFT JOIN
    person_relationships pr ON pr.relatedPersonId = p.id
WHERE
        DATE_FORMAT(birthDate, '%m-%d') = DATE_FORMAT(NOW(), '%m-%d') AND
        p.whetherDeleted = FALSE
        AND u.status = TRUE
        AND (p.isDeceased is null or p.isDeceased=FALSE)
        AND pr.relationship = 'MOTHER' group by u.id"
    
     WHERE `dataProviderId` = @dtproviderIdMother;
SET SQL_SAFE_UPDATES=1;